// mdNameExample.cpp
//
// Melissa Data mdName API for C++ Windows/Linux/Unix
// Copyright 1993-2007 Melissa Data Corporation.

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************


#include <stdio.h>
#include <string.h>

#include "mdName.h"

// Change the following lines to reflect your installation location
//   of the mdName API and the license string:
#define dFILELOC "C:\\Program Files\\Melissa Data\\DQT\\Data"

//********************** LICENSE STRINGS ***********************
//*     To unlock the full functionality of Name Object,       *
//*     	     Or to obtain a Demo License String            *
//* please call a sales representative at 1-800-MELISSA ext. 3 *
//*         (1-800-635-4772 x3) for a license string.          *
//**************************************************************

#define dLICENSE "Demo"

int main(int Argc,char *Argv) {
	char FullName[128];
	int Record=0;
	FILE *File;
	mdName *Name;
	const char* resultsString;
	
	printf("===============================\n");
	printf("    NAME OBJECT C++ EXAMPLE    \n");
	printf("===============================\n\n");

	Name=new mdName;
	if (!Name->SetLicenseString(dLICENSE)) {
		printf("Error setting License to \"%s\"\n",dLICENSE);
		printf("Please contact a sales representative at 1-800-800-6245 x3 for a valid license string");
		return 1;
	}
	Name->SetPathToNameFiles(dFILELOC);
	if (Name->InitializeDataFiles()!=mdName::NoError) {
		printf("Error Initializing mdName: \"%s\"\n",
			Name->GetInitializeErrorString());
		return 1;
	}
    printf("          Build Number: %s\n",Name->GetBuildNumber());
	printf("         Database Date: %s\n",Name->GetDatabaseDate());
	printf("DatabaseExpirationDate: %s\n",Name->GetDatabaseExpirationDate());
    printf(" LicenseExpirationDate: %s\n",Name->GetLicenseExpirationDate());

	// Set a few processing options:
	Name->SetPrimaryNameHint(mdName::VeryLikelyFull);
	Name->SetFirstNameSpellingCorrection(true);
	Name->SetSalutationPrefix("Dear");
	Name->SetSalutationSuffix(":");
	Name->SetSalutationSlug("Valued Customer");

	// Process the sample data file:
	File=fopen("C:\\Program Files\\Melissa DATA\\COM Objects\\Samples\\NameObj\\C++\\mdName.sdf","r");
	if (File==0) {
		printf("Could not open mdName.sdf\n");
		return 1;
	}

	while (fgets(FullName,128,File)!=0) {

		// Trim trailing CR/LFs:
		while (FullName[strlen(FullName)-1]=='\r' || FullName[strlen(FullName)-1]=='\n')
			FullName[strlen(FullName)-1]='\x0';


		Name->ClearProperties();
		Name->SetFullName(FullName);
		Name->Parse();

		printf("\nRecord %d Full Name: %s\n            Gender1: %s\n"
		  "            Prefix1: %s\n        First Name1: %s\n"
		  "       Middle Name1: %s\n         Last Name1: %s\n"
		  "            Suffix1: %s\n            Gender2: %s\n"
		  "            Prefix2: %s\n        First Name2: %s\n"
		  "       Middle Name2: %s\n         Last Name2: %s\n"
		  "            Suffix2: %s\n         Salutation: %s\n",
		 ++Record,FullName,Name->GetGender(),
		 Name->GetPrefix(),Name->GetFirstName(),
		 Name->GetMiddleName(),Name->GetLastName(),
		 Name->GetSuffix(),Name->GetGender2(),
		 Name->GetPrefix2(),Name->GetFirstName2(),
		 Name->GetMiddleName2(),Name->GetLastName2(),
		 Name->GetSuffix2(),Name->GetSalutation());

         resultsString = Name->GetResults();
          printf("\nResults Codes...\n");
        if (strstr(resultsString,"NS01")!=0)
	       printf("NS01: There were no Errors.\n");
	    if (strstr(resultsString,"NS03")!=0)
        printf("NS03: The spelling of the FirstName field was corrected.\n");
        if (strstr(resultsString,"NS04")!=0)
        printf("NS04: The spelling of the FirstName2 field was corrected.\n");
	
    if (strstr(resultsString,"NS02")!=0)
    {
        printf("NS02: Name Parse found an Error...\n");
        if (strstr(resultsString,"NE01")!=0)
           printf("NE01: Two names were detected but the FullName string was not in a recognized format.\n");
        if (strstr(resultsString,"NE02")!=0)
           printf("NE02: Multiple first names  could not accurately genderize.\n");

        if (strstr(resultsString,"NE03")!=0)
           printf("NE03: A vulgarity was detected in the name.\n");
        if (strstr(resultsString,"NE04")!=0)
           printf("NE04: The name contained words found on the list of nuisance names (such as Mickey Mouse).\n");
        if (strstr(resultsString,"NE05")!=0)
           printf("NE05: The name contained words normally found in a company name.\n");
        if (strstr(resultsString,"NE06")!=0)
           printf("NE06: The named contained a non-alphabetic character.\n");
	}


	}   // end while
	fclose(File);

	// Free the API:
	delete Name;
	return 0;
}


